ORCA/M Asm65816 2.1.0

0001 B200              ;==========================================================
0002 B200              ;
0003 B200              ;  file init.1
0004 B200              ;
0005 B200              ;  This is the interface area of the init package.  It is
0006 B200              ;  called by SCM in response to a $24 FORMAT or $25 ERASE_
0007 B200              ;  DISK application call.  In addition, it contains code
0008 B200              ;  and data which may be needed outside of the language cards.
0009 B200              ;
0010 B200              ;  Author:      Andy Stadler
0011 B200              ;  Created:     26-Jan-88
0012 B200              ;  Modified:    See modification history below
0013 B200              ;
0014 B200              ;  Copyright (C) 1988-1989 Apple Computer, Inc.
0015 B200              ;  All Rights Reserved.
0016 B200              ;
0017 B200              ;==========================================================
0018 B200              ;
0019 B200              ;  Modification history:
0020 B200              ;
0021 B200              ;  01-Feb-88    ADS     Initial release
0022 B200              ;  04-Feb-88    ADS     std_buffer, strings added
0023 B200              ;  15-Feb-88    ADS     strings removed  get_str_addr added
0024 B200              ;  23-Feb-88    ADS     crunching.  cp[n]_t2x_t3y created
0025 B200              ;  09-Jan-89    CAE     added init_pack_end routine
0026 B200              ;
0027 B200              ;==========================================================
0028 B200
0029 B200
0030 B200                       DataChk off
0031 B200                                                      ;using   common_equ
0032 B200                                                      ;using   init_equ
0033 B200                                                      ;using   fst_tbl_data
0034 B200                       longa on
0035 B200                       longi on
0036 B200
0037 B200                       Eject 
0038 B200              ;==========================================================
0039 B200              ;
0040 B200              ;  jsl init_pack
0041 B200              ;
0042 B200              ;  Is the entry point for SCM.
0043 B200              ;
0044 B200              ;  Inputs:      X = call number x 2
0045 B200              ;               Y = call class x 2
0046 B200              ;               dev_num = device number to be formatted
0047 B200              ;               path2_ptr = volume name of new volume
0048 B200              ;
0049 B200              ;  Outputs:     A = fst id if !C
0050 B200              ;                 = error # if C
0051 B200              ;                 = 0 if format cancelled
0052 B200              ;               X = trashed
0053 B200              ;               Y = trashed
0054 B200              ;               P = nvmxdizc
0055 B200              ;                   ..000..|
0056 B200              ;                          0 = no error, 1 = error
0057 B200              ;
0058 B200              ;  This routine may move memory.
0059 B200              ;
0060 B200              ;==========================================================
0061 B200
0062 B200              init_pack Proc Export
0063 B200                       Import init_main,lc_dispatcher
0064 B200
0065 B200 F4 00 00              pea   init_main>>16
0066 B203 F4 CE DE              pea   init_main
0067 B206              init_cont  
0068 B206 F4 01 00              pea   1                        ; into the card!
0069 B209 22 87 B1 00           jsl   lc_dispatcher
0070 B20D
0071 B20D 6B                    rtl   
0072 B20E
0073 B20E
0074 B20E              ;==========================================================
0075 B20E              ;
0076 B20E              ;  jsl init_pack_end
0077 B20E              ;
0078 B20E              ;  Entry point called by SCM after the format or erase is completed.
0079 B20E              ;
0080 B20E              ;  Inputs:      none
0081 B20E              ;
0082 B20E              ;  Outputs:     A = error # if C
0083 B20E              ;               X = trashed
0084 B20E              ;               Y = trashed
0085 B20E              ;               P = nvmxdizc
0086 B20E              ;                   ..000..|
0087 B20E              ;                          0 = no error, 1 = error
0088 B20E              ;
0089 B20E              ;  This routine may move memory.
0090 B20E              ;  This routine added 1/9/89 CAE.
0091 B20E              ;
0092 B20E              ;==========================================================
0093 B20E
0094 B20E                       EXPORT init_pack_end
0095 B20E              init_pack_end  
0096 B20E                       Import remove_msg
0097 B20E
0098 B20E F4 01 00              pea   remove_msg>>16
0099 B211 F4 F6 DE              pea   remove_msg
0100 B214 80 F0                 bra   init_cont
0101 B216                       EndP 
0102 B216
0103 B216                       Eject 
0104 B216              ****************************************************************************************************
0105 B216              *
0106 B216              save_my_dp Proc 
0107 B216              *
0108 B216              * Description
0109 B216              *       Saves the FST work area prior to making a call to an FST
0110 B216              *
0111 B216              * Inputs:
0112 B216              *       none
0113 B216              *
0114 B216              * Outputs:
0115 B216              *       none
0116 B216              *
0117 B216              * External Refs:
0118 B216                       with my_direct_page
0119 B216              *
0120 B216              * Entry Points:
0121 B216              *       none
0122 B216              *
0123 B216                       longa on                       ; mode
0124 B216                       longi on
0125 B216              *
0126 B216              ****************************************************************************************************
0127 B216
0128 B216 A2 4E 00              ldx   #my_dp_size-2
0129 B219              @loop     
0130 B219 B5 80                 lda   <my_direct_page,x        ;copy from direct page to save area
0131 B21B 9F 00 FD 01           sta   >saved_dp,x
0132 B21F CA                    dex   
0133 B220 CA                    dex   
0134 B221 10 F6                 bpl   @loop                    ;loop until X drops below $00
0135 B223 60                    rts   
0136 B224                       EndProc 
0137 B224
0138 B224
0139 B224                       Eject 
0140 B224              ****************************************************************************************************
0141 B224              *
0142 B224              restore_dp Proc 
0143 B224              *
0144 B224              * Description
0145 B224              *       Restores the contents of my direct page after a call to an FST
0146 B224              *
0147 B224              * Inputs:
0148 B224              *       none
0149 B224              *
0150 B224              * Outputs:
0151 B224              *       none
0152 B224              *
0153 B224              * External Refs:
0154 B224                       with my_direct_page
0155 B224              *
0156 B224              * Entry Points:
0157 B224              *       none
0158 B224              *
0159 B224                       longa on                       ; mode
0160 B224                       longi on
0161 B224              *
0162 B224              ****************************************************************************************************
0163 B224
0164 B224 08                    php                            ;save status
0165 B225 48                    pha                            ;and possible error code
0166 B226 A2 4E 00              ldx   #my_dp_size-2
0167 B229              @loop     
0168 B229 BF 00 FD 01           lda   >saved_dp,x              ;copy from save area to direct page
0169 B22D 95 80                 sta   <my_direct_page,x
0170 B22F CA                    dex   
0171 B230 CA                    dex   
0172 B231 10 F6                 bpl   @loop                    ;until X drops below $00
0173 B233
0174 B233 68                    pla                            ;restore accumulator
0175 B234 28                    plp                            ; and status
0176 B235 60                    rts   
0177 B236                       EndProc 
0178 B236
0179 B236                       Eject 
0180 B236              ****************************************************************************************************
0181 B236              *
0182 B236              call_judgename Proc Export
0183 B236              *
0184 B236              * Description
0185 B236              *       Used by Init Manager to perform an internal call to an FST's JudgeName
0186 B236              *       facility.  Must first buffer off some SCM variables, then call a SCM
0187 B236              *       internal entry point, then restore SCM's variables.
0188 B236              *
0189 B236              * Inputs:
0190 B236              *       jn_parms set up properly
0191 B236              *
0192 B236              * Outputs:
0193 B236              *       Acc = error code from JudgeName call, if any
0194 B236              *       jn_parms contains parameters returned from call
0195 B236              *
0196 B236              * External Refs:
0197 B236                       Import do_judgename,jn_parms
0198 B236                       Import class,num               ; in SCM
0199 B236              *
0200 B236              * Entry Points:
0201 B236              *       none
0202 B236              *
0203 B236                       longa on                       ; mode
0204 B236                       longi on
0205 B236              *
0206 B236              ****************************************************************************************************
0207 B236
0208 B236 8B                    phb                            ; save current DBR
0209 B237 F4 00 00              pea   $0000                    ; set to SCM's data bank
0210 B23A AB                    plb   
0211 B23B AB                    plb   
0212 B23C
0213 B23C D4 32                 pei   <param_blk_ptr           ;Save parameter block pointer.
0214 B23E D4 34                 pei   <param_blk_ptr+2
0215 B240 A9 81 B2              lda   #jn_parms                ;Set param_blk_ptr to our parms.
0216 B243 85 32                 sta   <param_blk_ptr
0217 B245 A9 00 00              lda   #jn_parms>>16
0218 B248 85 34                 sta   <param_blk_ptr+2
0219 B24A
0220 B24A D4 30                 pei   <call_number             ;Save call number.
0221 B24C A9 07 20              lda   #$2007                   ;Set call number (JudgeName).
0222 B24F 85 30                 sta   <call_number
0223 B251
0224 B251 AD A0 B9              lda   |num                     ;Save num
0225 B254 48                    pha   
0226 B255 A9 0E 00              lda   #7*2                     ;Set num to call # times 2.
0227 B258 8D A0 B9              sta   |num
0228 B25B
0229 B25B AD A2 B9              lda   |class                   ;Save class.
0230 B25E 48                    pha   
0231 B25F A9 02 00              lda   #0002                    ;Set to class 1.
0232 B262 8D A2 B9              sta   |class
0233 B265
0234 B265 20 16 B2              jsr   save_my_dp               ; save my direct page values
0235 B268 20 70 E6              jsr   do_judgename             ; make the JudgeName call
0236 B26B 20 24 B2              jsr   restore_dp               ; restore my direct page values
0237 B26E
0238 B26E FA                    plx                            ;Restore class.
0239 B26F 8E A2 B9              stx   |class
0240 B272
0241 B272 FA                    plx                            ;Restore num.
0242 B273 8E A0 B9              stx   |num
0243 B276
0244 B276 FA                    plx                            ;Restore call number.
0245 B277 86 30                 stx   <call_number
0246 B279 FA                    plx                            ;Restore parameter block pointer.
0247 B27A 86 34                 stx   <param_blk_ptr+2
0248 B27C FA                    plx   
0249 B27D 86 32                 stx   <param_blk_ptr
0250 B27F AB                    plb                            ; restore my DBR
0251 B280 6B                    rtl   
0252 B281
0253 B281                       export jn_parms
0254 B281 00 00 00 00  jn_parms ds jn_parmBlock                ;parameter block for JudgeName call
0255 B293
0256 B293                       EndProc 
0257 B293
0258 B293
0259 B293
0260 B293                       eject 
0261 B293              ;==========================================================
0262 B293              ;
0263 B293              ;  cp[n]_t2x_t3y
0264 B293              ;
0265 B293              ;  Copies n words of data from [<init_temp_2],x
0266 B293              ;  to [<init_temp_3],y and increments each by 2n.
0267 B293              ;
0268 B293              ;  Inputs:      init_temp_2 = source base
0269 B293              ;               init_temp_3 = dest base
0270 B293              ;               X = source data offset
0271 B293              ;               Y = dest data offset
0272 B293              ;
0273 B293              ;  Outputs:     A = trashed
0274 B293              ;               X = incremented by 2n
0275 B293              ;               Y = incremented by 2n
0276 B293              ;               P = nvmxdizc
0277 B293              ;                   ..000...
0278 B293              ;
0279 B293              ;==========================================================
0280 B293
0281 B293              cp8_t2x_t3y Proc Export
0282 B293                       Export CP1_T2X_T3Y,CP4_T2X_T3Y
0283 B293                       with my_direct_page
0284 B293
0285 B293 22 97 B2 00           jsl   cp4_t2x_t3y
0286 B297              cp4_t2x_t3y  
0287 B297 22 9B B2 00           jsl   cp2_t2x_t3y
0288 B29B              cp2_t2x_t3y  
0289 B29B 22 9F B2 00           jsl   cp1_t2x_t3y
0290 B29F
0291 B29F              cp1_t2x_t3y  
0292 B29F 5A                    phy   
0293 B2A0 9B                    txy   
0294 B2A1 B7 AE                 lda   [<init_temp_2],y
0295 B2A3 7A                    ply   
0296 B2A4 97 B2                 sta   [<init_temp_3],y
0297 B2A6 E8                    inx   
0298 B2A7 E8                    inx   
0299 B2A8 C8                    iny   
0300 B2A9 C8                    iny   
0301 B2AA 6B                    rtl   
0302 B2AB                       EndP 
0303 B2AB
0304 B2AB                       eject 
0305 B2AB              ;==========================================================
0306 B2AB              ;
0307 B2AB              ;  jsl get_msg_address
0308 B2AB              ;
0309 B2AB              ;  called by the language card stuff to get the address
0310 B2AB              ;  of the strings table.
0311 B2AB              ;
0312 B2AB              ;==========================================================
0313 B2AB
0314 B2AB              get_msg_address Proc Export
0315 B2AB                       Import e1_msg_address
0316 B2AB
0317 B2AB AF F3 D6 E1           lda   >e1_msg_address
0318 B2AF AA                    tax   
0319 B2B0 AF F5 D6 E1           lda   >e1_msg_address+2
0320 B2B4 A8                    tay   
0321 B2B5 6B                    rtl   
0322 B2B6                       EndP 
0323 B2B6
0324 B2B6                       eject 
0325 B2B6              ;==========================================================
0326 B2B6              ;
0327 B2B6              ;  Contained here is data which MUST be in non-language
0328 B2B6              ;  card area, because it is accessed by the console driver.
0329 B2B6              ;
0330 B2B6              ;==========================================================
0331 B2B6
0332 B2B6              std_buffer Record Export
0333 B2B6 00 00 00 00           DC L:0
0334 B2BA
0335 B2BA                       Export set_list_str
0336 B2BA 06           set_list_str DC B:6
0337 B2BB 01 02                 DC B:$01,$02                   ; push vp, set vp
0338 B2BD 00 00 00 00           DC B:0,0,0,0
0339 B2C1
0340 B2C1              ; the order of the following terminators is important.  If you change it, you must
0341 B2C1              ; change the constant comparison operands in 'handle_edit'
0342 B2C1
0343 B2C1                       Export term_list,term_list_len:equ
0344 B2C1              term_list  
0345 B2C1 7F E3                 DC B:$7f,%11100011             ; termMask
0346 B2C3 05 00                 DC W:5                         ; termCount (5 terminators)
0347 B2C5 0D 80                 DC B:$0d,%10000000             ; Return w/Apple key
0348 B2C7 1B 00                 DC B:$1b,%00000000             ; Esc
0349 B2C9 09 00                 DC B:$09,%00000000             ; Tab
0350 B2CB 3F A1                 DC B:'?',%10100001             ; Open-Apple ?, interrupt
0351 B2CD 2F A0                 DC B:'/',%10100000             ; Open-Apple /, interrupt
0352 B2CF              term_list_end  
0353 B2CF              term_list_len equ   term_list_end-term_list
0354 B2CF
0355 B2CF                       Export dflt_input_port
0356 B2CF 20           dflt_input_port DC B:' '                ; fillChar
0357 B2D0 80                    DC B:$80                       ; defCursor
0358 B2D1 80                    DC B:$80                       ; cursorMode
0359 B2D2 FF                    DC B:$FF                       ; beepFlag
0360 B2D3 00                    DC B:$00                       ; entryType
0361 B2D4
0362 B2D4                       Export input_port
0363 B2D4 00 00 00 00  input_port ds InputPortRec
0364 B2E4
0365 B2E4                       EndR 
0366 B2E4                       DataChk on
0367 B2E4
0368 B2E4              ;===============================================================================
0369 B2E4              ;
0370 B2E4              ; init.1.e
0371 B2E4              ;
0372 B2E4              ;===============================================================================
0373 B2E4
0374 B2E4              init_1_end PROC 
0375 B2E4                       ENDP 
0376 B2E4
0377 B2E4              init_1_dummy PROC org init_1_max, skip  ;generate an error if code is too big
0378 B2E4                       ENDP 
0379 B2E4
0380 B2E4                       END   
